/*
	File:		ColorUtils.h

	Contains:	Macros to help drawing in color.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

#ifndef __COLOR_UTILS__
#define __COLOR_UTILS__

#include "ColorPenState.h"

enum {
	kBlack			= 0,
	kGrayLevel1		= 0x1111,
	kGrayLevel2		= 0x2222,
	kGrayLevel3		= 0x3333,
	kGrayLevel4		= 0x4444,
	kGrayLevel5		= 0x5555,
	kGrayLevel6		= 0x6666,
	kGrayLevel7		= 0x7777,
	kGrayLevel8		= 0x8888,
	kGrayLevel9		= 0x9999,
	kGrayLevelA		= 0xAAAA,
	kGrayLevelB		= 0xBBBB,
	kGrayLevelC		= 0xCCCC,
	kGrayLevelD		= 0xDDDD,
	kGrayLevelE		= 0xEEEE,
	kWhite			= 0xFFFF
};

#define IsColorGrafPort( port ) (((port)->portBits.rowBytes & 0xC000) == 0xC000)
#define GetCurrentDepth( port )	( IsColorGrafPort( port ) ? (**((CGrafPtr)port)->portPixMap).pixelSize : 1 )
#define MakeGray( color, gray ) ((color).red = (color).green = (color).blue = gray )
 
#define SetForeGray( gray )	\
	do { RGBColor temp; temp.red = temp.green = temp.blue = (gray); RGBForeColor( &temp ); } while( 0 )
#define SetBackGray( gray )	\
	do { RGBColor temp; temp.red = temp.green = temp.blue = (gray); RGBBackColor( &temp ); } while( 0 )

#endif // __COLOR_UTILS__
